package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * 描述：req_log模型
 *
 * @author xiachenhang
 * @date 2020-01-09 15:33:00
 */
@Data
public class ReqLog implements Serializable{

    @ApiModelProperty("唯一标识")
    private Long logId;

    @ApiModelProperty("请求地址")
    private Long userId;

    @ApiModelProperty("请求地址")
    private String url;

    @ApiModelProperty("返回状态")
    private String code;

    @ApiModelProperty("返回信息")
    private String msg;

    @ApiModelProperty("上游类型:ssq 1")
    private String type;

    @ApiModelProperty("请求方式:get/post 1/2")
    private String method;

    @ApiModelProperty("请求参数")
    private String param;

    @ApiModelProperty("返回结果(所有)")
    private String response;

    @ApiModelProperty("具体的动作:上游接口类型")
    private String action;

    @ApiModelProperty("流水号")
    private String serialNumber;

    @ApiModelProperty("所需的内容")
    private String data;
}