package cn.com.duiba.youqian.center.api.util;

import org.apache.commons.lang.StringUtils;

import java.text.DecimalFormat;
import java.util.Random;

/**
 * @Description: 格式化数字为千分位工具类
 * @author xiachenhang
 */
public class FmtMicrometerUtil {
    /**
     * @Title: fmtMicrometer
     * @Description: 格式化数字为千分位
     * @param text
     * @return    设定文件
     * @return String    返回类型
     */
    public static String fmtMicrometer(String text) {
        DecimalFormat df = null;
        double number = 0.0;
        if(StringUtils.isEmpty(text)){
            return String.valueOf(number);
        }
        if (text.indexOf(".") > 0) {
            if (text.length() - text.indexOf(".") - 1 == 0) {
                df = new DecimalFormat("###,##0.");
            } else if (text.length() - text.indexOf(".") - 1 == 1) {
                df = new DecimalFormat("###,##0.0");
            } else {
                df = new DecimalFormat("###,##0.00");
            }
        } else {
            df = new DecimalFormat("###,##0");
        }
        try {
            number = Double.parseDouble(text);
        } catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

}
