package cn.com.duiba.youqian.center.api.enums;

import cn.com.duiba.youqian.center.api.entity.RoleMenu;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author tengtuox
 * @date 2019/12/30
 * @description 后台左侧菜单
 */
@Getter
public enum EnumMenu {

    /**
     * 销售管理
     */
    SALE(1, "销售管理", 1, 0, 1, true),
    ORDER_CONTRACT(11, "订单合约管理", 2, 1, 1, true),
    CONTRACT_TEMPLATE(12, "合同模板管理", 2, 1, 1, true),
    GOODS(13, "商品管理", 2, 1, 1, true),
    CUSTOMER(14, "客户管理", 2, 1, 1, true),

    /**
     * 系统管理
     */
    SYSTEM(2, "系统管理", 1, 0, 1, true),
    ORGANIZATION(21, "部门管理", 2, 2, 1, true),
    APPROVAL(22, "审批管理", 2, 2, 1, false),
    EMPLOYEE(23, "员工管理", 2, 2, 1, true),

    /**
     * 采购管理
     */
    BUY(3, "采购管理", 1, 0, 1, false),
    BUY_ORDER(31, "订单管理", 2, 3, 1, false),

    /**
     * 商户管理
     */
    PLATFORM_MERCHANT(4, "商户管理", 1, 0, 2, true),
    MERCHANT_LIST(41, "商户列表", 2, 4, 2, true),
    SIGN_ENTITY(42, "签约主体", 2, 4, 2, true),

    /**
     * 平台系统管理
     */
    PLATFORM_SYSTEM(5, "系统管理", 1, 0, 2, false),
    PLATFORM_MENU(51, "菜单管理", 2, 5, 2, false),
    PLATFORM_ROLE(52, "角色管理", 2, 5, 2, false),

    /**
     * 用户管理
     */
    USER(6, "用户管理", 1, 0, 2, true),
    BUY_ACCOUNT(61, "买家账号", 1, 6, 2, true),
    SELL_ACCOUNT(62, "卖家账号", 1, 6, 2, true),
    PLATFORM_ACCOUNT(63, "平台账号", 1, 6, 2, true),

    /**
     * 模板库管理
     */
    TEMPLATE(7, "模板库管理", 1, 0, 2, true),
    ;

    /**
     * 菜单ID，不能重复不能修改
     */
    private Integer menuId;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 菜单级别
     */
    private Integer level;

    /**
     * 父菜单ID
     * 没有父菜单时=0
     */
    private Integer parentMenuId;

    /**
     * 1-商户菜单
     * 2-平台菜单
     */
    private Integer type;

    /**
     * 是否展示
     * 有些未开发完成的菜单显示false
     */
    private boolean show;

    EnumMenu(Integer menuId, String menuName, Integer level, Integer parentMenuId, Integer type, boolean show) {
        this.menuId = menuId;
        this.menuName = menuName;
        this.level = level;
        this.parentMenuId = parentMenuId;
        this.type = type;
        this.show = show;
    }

    public static List<EnumMenu> merchantMenuList() {
        List<EnumMenu> list = new ArrayList<>();
        for (EnumMenu e : EnumMenu.values()) {
            if (e.getType() == 1 && e.isShow()) {
                list.add(e);
            }
        }
        return list;
    }

    public RoleMenu getRoleMenu(Long merchantId) {
        RoleMenu roleMenu = new RoleMenu();
        roleMenu.setMerchantId(merchantId);
        roleMenu.setParentMenuId(parentMenuId);
        roleMenu.setMenuId(menuId);
        roleMenu.setMenuLevel(level);
        roleMenu.setMenuName(menuName);
        return roleMenu;
    }

    public static List<EnumMenu> roleManagerMenu() {
        List<EnumMenu> list = new ArrayList<>();
        for (EnumMenu e : EnumMenu.values()) {
            if (e.getType() == 2 && e.isShow()) {
                list.add(e);
            }
        }
        return list;
    }
}
