package cn.com.duiba.youqian.center.api.request.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

@Data
public class AddOrderRequest implements Serializable {

    @NotBlank
    @ApiModelProperty(value = "买家名字(个人)", required = true)
    private String buyerName;

    @NotBlank
    @ApiModelProperty(value = "买家手机号(个人)", required = true)
    private String phoneNumber;

    @ApiModelProperty(value = "买家公司名(个人)", required = true)
    private String companyName;

    @ApiModelProperty(value = "买方类型 0-个人 1-企业", required = true)
    public Integer buyerType;

    @ApiModelProperty(value = "买方签约主体(企业)", required = true)
    public String entityName;

    @ApiModelProperty(value = "买方联系人(企业)", required = true)
    public String entityUserName;

    @ApiModelProperty(value = "买方联系电话(企业)", required = true)
    public String entityMobile;

    @NotBlank
    @ApiModelProperty(value = "订单编号", required = true)
    private String orderNo;

    @NotBlank
    @ApiModelProperty(value = "收货人姓名", required = true)
    private String name;

    @NotBlank
    @ApiModelProperty(value = "收货人手机号", required = true)
    private String mobile;

    @NotBlank
    @ApiModelProperty(value = "收货地址", required = true)
    private String address;

}
