package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * `merchant`
 */
@Data
public class Merchant implements Serializable {
    private static final long serialVersionUID = -4804692472929066451L;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("商户名称")
    private String merchantName;

    @ApiModelProperty("商户别名（代号）")
    private String merchantNickname;

    @ApiModelProperty("商户LOGO")
    private String logo;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String areaCode;

    @ApiModelProperty("剩余合同数量")
    private Integer remainContract;

    @ApiModelProperty("总共合同数量")
    private Integer totalContract;

    @ApiModelProperty("过期时间")
    private Date expireDate;

    @ApiModelProperty("状态/0-正常，1-停用")
    private Byte merchantStatus;

    @ApiModelProperty("签约主体个数")
    private Integer signEntityCount;

    @ApiModelProperty("联系电话")
    private String contactMobile;

    @ApiModelProperty("联系人姓名")
    private String contactName;

    @ApiModelProperty("创建人/申请人")
    private Long createUserId;
}