package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * `pay_order`
 */
@Data
public class PayOrder implements Serializable {
    @ApiModelProperty("支付单ID")
    private Long id;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("订单创建人")
    private Long createUserId;

    @ApiModelProperty("订单创建人账号")
    private String createAccount;

    @ApiModelProperty("支付人ID")
    private Long payUserId;

    @ApiModelProperty("订单ID")
    private Long orderId;

    @ApiModelProperty("自定义订单编号")
    private String orderNo;

    @ApiModelProperty("微信订单编号")
    private String wxOrderNo;

    @ApiModelProperty("实际价格")
    private BigDecimal price;

    @ApiModelProperty("支付单状态,1-待付款，2-已付款，3-已退款")
    private Byte payStatus;

    @ApiModelProperty("付款时间")
    private Date payTime;
}