package cn.com.duiba.youqian.center.api.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.youqian.center.api.entity.RoleMenu;
import cn.com.duiba.youqian.center.api.exception.StandardCode;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * @author tengtuox
 * @date 2019/12/30
 * @description 后台左侧菜单
 */
@Getter
public enum EnumMenu {

    /**
     * 销售管理
     */
    SALE(1, "销售管理", 1, 0, 1, true),
    ORDER_CONTRACT(11, "合约列表", 2, 1, 1, true),
    ORDER_DETAIL(111, "订单详情", 3, 11, 1, false),
    CUSTOMER(14, "我的客户", 2, 1, 1, true),
    GOODS(13, "商品列表", 2, 1, 1, true),
    CONTRACT_TEMPLATE(12, "我的模板", 2, 1, 1, true),
    TEMPLATE_ALL(15, "模板库", 2, 1, 1, true),

    /**
     * 系统管理
     */
    SYSTEM(2, "系统管理", 1, 0, 1, true),
    EMPLOYEE(23, "员工账号", 2, 2, 1, true),
    ORGANIZATION(21, "部门管理", 2, 2, 1, true),
    APPROVAL(22, "审批管理", 2, 2, 1, true),
    SIGN_ENTITY(24, "签约主体", 2, 2, 1, true),
    ENTITY_AUTH(241, "企业认证", 3, 24, 2, false),

    /**
     * 采购管理
     */
    BUY(3, "采购管理", 1, 0, 1, true),
    BUY_ORDER(31, "订单管理", 2, 3, 1, true),

    /**
     * 商户管理
     */
    PLATFORM_MERCHANT(4, "商户管理", 1, 0, 2, true),
    MERCHANT_LIST(41, "商户列表", 2, 4, 2, true),
    PLATFORM_SIGN_ENTITY(42, "签约主体", 3, 41, 2, false),
    PLATFORM_ENTITY_AUTH(411, "企业认证", 3, 41, 2, false),

    /**
     * 用户管理
     */
    USER(6, "用户管理", 1, 0, 2, true),
    SELL_ACCOUNT(62, "卖方账号", 1, 6, 2, true),
    BUY_ACCOUNT(61, "买方账号", 1, 6, 2, true),
    PLATFORM_ACCOUNT(63, "平台账号", 1, 6, 2, true),

    /**
     * 平台系统管理
     */
    PLATFORM_SYSTEM(5, "平台管理", 1, 0, 2, true),
    PLATFORM_ROLE(51, "角色管理", 2, 5, 2, true),
    TEMPLATE(7, "合同模板库", 2, 5, 2, true),
    ;

    /**
     * 菜单ID，不能重复不能修改
     */
    private Integer menuId;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 菜单级别
     */
    private Integer level;

    /**
     * 父菜单ID
     * 没有父菜单时=0
     */
    private Integer parentMenuId;

    /**
     * 1-商户菜单
     * 2-平台菜单
     */
    private Integer type;

    /**
     * 是否展示
     * 有些未开发完成的菜单显示false
     */
    private boolean show;

    /**
     * 顺序
     */
    private Integer order = this.ordinal();

    EnumMenu(Integer menuId, String menuName, Integer level, Integer parentMenuId, Integer type, boolean show) {
        this.menuId = menuId;
        this.menuName = menuName;
        this.level = level;
        this.parentMenuId = parentMenuId;
        this.type = type;
        this.show = show;
    }

    public static List<EnumMenu> merchantMenuList() {
        List<EnumMenu> list = new ArrayList<>();
        for (EnumMenu e : EnumMenu.values()) {
            if (e.getType() == 1) {
                list.add(e);
            }
        }
        list.sort(Comparator.comparingInt(o -> o.order));
        return list;
    }

    public static EnumMenu getByMenuId(Integer menuId) throws BizException {
        for (EnumMenu enumMenu : EnumMenu.values()) {
            if (enumMenu.getMenuId().equals(menuId)) {
                return enumMenu;
            }
        }

        throw new BizException("菜单不存在").withCode(StandardCode.PARAM_ERROR.getStrCode());
    }

    public RoleMenu getRoleMenu(Long merchantId) {
        RoleMenu roleMenu = new RoleMenu();
        roleMenu.setMerchantId(merchantId);
        roleMenu.setParentMenuId(parentMenuId);
        roleMenu.setMenuId(menuId);
        roleMenu.setMenuLevel(level);
        roleMenu.setMenuName(menuName);
        return roleMenu;
    }

    public static List<EnumMenu> roleManagerMenu() {
        List<EnumMenu> list = new ArrayList<>();
        for (EnumMenu e : EnumMenu.values()) {
            if (e.getType() == 2) {
                list.add(e);
            }
        }
        list.sort(Comparator.comparingInt(o -> o.order));
        return list;
    }
}
