package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.ManageRole;
import cn.com.duiba.youqian.center.api.request.manage.AddManageRoleRequest;
import cn.com.duiba.youqian.center.api.request.manage.UpdateManageRoleRequest;
import cn.com.duiba.youqian.center.api.result.manage.ManageRoleVO;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/2/14
 * @description
 */
@AdvancedFeignClient
public interface RemoteManageRoleService {

    /**
     * 添加角色
     *
     * @param request request
     * @return RoleId
     * @throws BizException 角色已存在
     */
    Long addRole(AddManageRoleRequest request) throws BizException;

    /**
     * 修改非空部分
     *
     * @param request request
     * @throws BizException 角色不存在
     */
    void updateRole(UpdateManageRoleRequest request) throws BizException;

    /**
     * 查询角色
     *
     * @param roleId roleId
     * @return ManageRole
     * @throws BizException 角色不存在
     */
    ManageRole getRole(Long roleId) throws BizException;

    /**
     * 获取角色详情
     *
     * @param roleId roleId
     * @return ManageRoleVO，包含角色权限和菜单权限
     * @throws BizException 角色不存在
     */
    ManageRoleVO getRoleDetail(Long roleId) throws BizException;

    /**
     * 获取所有角色
     *
     * @return List<ManageRole>
     */
    List<ManageRole> getAllRole() throws BizException;

}
