package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.Order;
import cn.com.duiba.youqian.center.api.request.order.*;
import cn.com.duiba.youqian.center.api.request.template.TemplateFieldRequest;
import cn.com.duiba.youqian.center.api.request.template.TemplateReq;
import cn.com.duiba.youqian.center.api.result.PageResult;
import cn.com.duiba.youqian.center.api.result.order.*;
import cn.com.duiba.youqian.center.api.result.order.OrderContractVO;
import cn.com.duiba.youqian.center.api.result.order.OrderDescVO;
import cn.com.duiba.youqian.center.api.result.order.OrderListVO;
import cn.com.duiba.youqian.center.api.result.order.OrderSignVO;
import cn.com.duiba.youqian.center.api.result.sign.SignVO;
import cn.com.duiba.youqian.center.api.result.user.UserVO;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteOrderService {
    /**
     * 创建订单并返回订单编号
     * @param userId 卖家的id
     * @param orderInfoRequest 订单商户的基本信息
     * @return
     */
    OrderContractVO create(Long userId, OrderInfoRequest orderInfoRequest) throws BizException;

    /**
     * 更新订单
     * @param userId 登陆人的ID
     * @param orderRequest 买家的信息
     * @return
     */
    void updateOrder(Long userId, AddOrderRequest orderRequest) throws BizException;


    /**
     *
     * 订单详情
     *
     * @param orderId orderId
     * @return OrderDetail
     * @throws BizException 订单不存在
     */
    OrderDetail getOrderDetail(Long orderId) throws BizException;

    /**
     * 查询卖家对应的买家及信息
     * @param userId 卖家登录ID
     * @return
     */
    String getContractTemplate(Long userId, TemplateFieldRequest templateFieldRequest) throws BizException;

    /**
     * 返回首页的订单列表sellSignEntityId
     * @param orderRequest
     * @return
     */
    PageResult<OrderListVO> list(OrderRequest orderRequest);

    /**
     * 取消订单
     * @param orderNo 订单编号
     */
    void cancelOrder(String orderNo) throws BizException;

    /**
     * 处理订单合同
     * @param account 上上签唯一的标识
     * @param contractId 合同ID
     * @param orderNo 订单编号
     * @param signerStatus 签署状态
     */
    void handleOrderContract(String account, String contractId,String orderNo, String signerStatus) throws BizException;

    /**
     * 首页-签约统计
     * @param userId 当前登录的用户
     * @param type 当前登录的权限
     * @return
     */
    OrderSignVO countSign(Long userId,Integer type);

    /**
     * 查询订单的详情
     * @param userId 用户id
     * @param orderNo 订单编号
     * @return
     * @throws BizException
     */
    OrderDescVO getOrderDescById(Long userId, String orderNo) throws BizException;

    /**
     * 查询卖家对应的买家及信息
     * @param userId 卖家登录ID
     * @return
     */
    List<UserVO> getRelevanceUser(Long userId);

    /**
     * 获取卖家的签约主体
     * @param
     */
    List<SignVO> getShellSignEntity(Long userId);

    /**
     * 商户后台搜索订单（订单列表）
     *
     * @param request request
     * @return PageResult<Order>
     */
    PageResult<Order> searchOrder(SearchOrderRequest request) throws BizException;

    /**
     * 商户后台采购搜索订单
     *
     * @param request request
     * @return PageResult<Order>
     */
    PageResult<Order> searchBuyerOrder(SearchBuyerOrderRequest request) throws BizException;

    /**
     * 修改订单为发送成功的状态
     */
    void sendOrderSuccess(String orderNo) throws BizException;

    /**
     * 生成订单编号
     *
     * @return 订单编号
     */
    String genOrderNo() throws BizException;
}
