package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.MerchantTemplate;
import cn.com.duiba.youqian.center.api.entity.Template;
import cn.com.duiba.youqian.center.api.entity.TemplateField;
import cn.com.duiba.youqian.center.api.request.contract.AddTemplateRequest;
import cn.com.duiba.youqian.center.api.request.contract.PageTemplateRequest;
import cn.com.duiba.youqian.center.api.request.contract.UpGradeTemplateRequest;
import cn.com.duiba.youqian.center.api.request.merchant.PageMerchantTemplateRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;
import cn.com.duiba.youqian.center.api.result.contract.MerchantTemplateVO;
import cn.com.duiba.youqian.center.api.result.template.TemplateVO;
import cn.com.duiba.youqian.center.api.result.template.TemplateValueVO;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/11
 * @description
 */
@AdvancedFeignClient
public interface RemoteTemplateService {

    /**
     * 模板分页
     */
    PageResult<Template> templatePageList(PageTemplateRequest request) throws BizException;

    /**
     * 模板详情
     *
     * @param templateId 模板ID
     * @throws BizException 模板不存在
     */
    Template get(Long templateId) throws BizException;

    /**
     * 更新模板基本信息
     *
     * @param template 非空更新
     * @throws BizException 模板不存在
     */
    void update(Template template) throws BizException;

    /**
     * 升级模板
     *
     * @param request request
     * @return 新的模板ID
     * @throws BizException 模板已存在
     */
    Long upgrade(UpGradeTemplateRequest request) throws BizException;

    /**
     * 新增模板
     *
     * @param request 非空新增
     * @return 模板ID
     * @throws BizException 模板已存在
     */
    Long add(AddTemplateRequest request) throws BizException;

    /**
     * 模板列表
     *
     * @param request request
     */
    PageResult<MerchantTemplateVO> mTemplatePage(PageMerchantTemplateRequest request) throws BizException;

    /**
     * 新增模板
     *
     * @param merchantTemplate merchantTemplate
     * @return 主键ID
     * @throws BizException 模板已经添加
     */
    Long addMerchantTemplate(MerchantTemplate merchantTemplate) throws BizException;

    /**
     * 更新模板
     *
     * @param merchantTemplate merchantTemplate
     * @throws BizException 模板不存在
     */
    void updateMerchantTemplate(MerchantTemplate merchantTemplate) throws BizException;

    /**
     * 返回模板参数字段
     *
     * @param merchantId 商户ID
     * @param templateId 模板ID
     */
    List<TemplateVO> getTemplateField(Long merchantId, Long templateId) throws BizException;

    /**
     * 根据orderId获取所有模板值
     *
     * @param orderId orderId
     * @return List<TemplateValueVO>
     */
    List<TemplateValueVO> getTemplateValue(Long orderId) throws BizException;

    /**
     * 删除templateField
     *
     * @param templateId templateId
     */
    void deleteTemplateField(Long templateId) throws BizException;

    /**
     * 添加templateField
     *
     * @param templateField templateField
     */
    void addTemplateField(TemplateField templateField) throws BizException;

}
