package cn.com.duiba.youqian.center.api.request.merchant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/2/24
 * @description
 */
@Data
public class TransferEntRequest implements Serializable {
    private static final long serialVersionUID = 5635097621528056255L;

    @ApiModelProperty("商户ID（前端忽略）")
    private Long merchantId;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "签约主体ID", required = true)
    private Long signEntityId;

    @NotBlank
    @ApiModelProperty(value = "企业名称", required = true)
    private String entName;

    @NotBlank
    @ApiModelProperty(value = "法人手机号", required = true)
    private String legalMobile;

    @NotBlank
    @ApiModelProperty(value = "法人名称", required = true)
    private String legalPerson;

    @NotBlank
    @ApiModelProperty(value = "短信验证码", required = true)
    private String messageCode;
}
