package cn.com.duiba.youqian.center.api.request.merchant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/11
 * @description
 */
@Data
public class UpdateEmpRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "员工编号", required = true)
    private Long employeeId;

    @NotBlank
    @ApiModelProperty(value = "姓名", required = true)
    private String employeeName;

    @NotNull
    @ApiModelProperty(value = "是否可开单", required = true)
    private Boolean canOpenOrder;

    @ApiModelProperty("可使用的主体signEntityId列表")
    private List<String> canUseEntityList;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("组织名称")
    private String orgName;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "角色ID", required = true)
    private Long roleId;

}
