package cn.com.duiba.youqian.center.api.request.template;

import cn.com.duiba.youqian.center.api.annotation.TempField;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class TemplateOtherFieldVO implements Serializable {
    @TempField(name = "其他约定事项")
    private String otherDesc;

    @TempField(name = "定金")
    private String firstPayment;

    @TempField(name = "定金付款时间")
    private String firstPaymentTime;

    @TempField(name = "尾款")
    private String lastPayment;

    @TempField(name = "尾款付款时间")
    private String lastPaymentTime;

    @TempField(name = "付款金额")
    private String payment;

    @TempField(name = "付款时间")
    private String paymentTime;

    @TempField(name = "运费")
    private String freight;

    @TempField(name = "物流运输")
    private String transportWay;

    @TempField(name = "交货时间")
    private String deliveryTime;

    @TempField(name = "是否定金")
    private Boolean isPayment;

    public TemplateOtherFieldVO format(){
        this.setTransportWay(TransportWayEnum.get(StringUtils.isEmpty(this.getTransportWay())?null:Integer.parseInt(this.getTransportWay())));
        this.setFirstPaymentTime(FirstPaymentEnum.get(StringUtils.isEmpty(this.getFirstPaymentTime())?null:Integer.parseInt(this.getFirstPaymentTime())));
        this.setPaymentTime(LastPaymentEnum.get(StringUtils.isEmpty(this.getPaymentTime())?null:Integer.parseInt(this.getPaymentTime())));
        this.setLastPaymentTime(LastPaymentEnum.get(StringUtils.isEmpty(this.getLastPaymentTime())?null:Integer.parseInt(this.getLastPaymentTime())));
        return this;
    }

    @Getter
    enum TransportWayEnum{
        TRANSPORT_1(1,"甲方上门自提"),
        TRANSPORT_2(2,"乙方送货上门"),
        TRANSPORT_3(3,"以【备注】约定为准");
        private Integer code;
        private String msg;
        TransportWayEnum(Integer code,String msg){
            this.code = code;
            this.msg = msg;
        }
        public static String get(Integer code){
            if(code == null){
                return "";
            }
            for(TransportWayEnum transport : values()){
                if(code.equals(transport.getCode())){
                    return transport.getMsg();
                }
            }
            return "";
        }
    }
    @Getter
    enum FirstPaymentEnum{
        PAYMENT_1(1,"发货前7个工作日内"),
        PAYMENT_2(2,"以【备注】约定为准");
        private Integer code;
        private String msg;
        FirstPaymentEnum(Integer code,String msg){
            this.code = code;
            this.msg = msg;
        }
        public static String get(Integer code){
            if(code == null){
                return "";
            }
            for(FirstPaymentEnum firstPaymentEnum : values()){
                if(code.equals(firstPaymentEnum.getCode())){
                    return firstPaymentEnum.getMsg();
                }
            }
            return "";
        }
    }
    @Getter
    enum LastPaymentEnum{
        PAYMENT_1(1,"收货后7个工作日内"),
        PAYMENT_2(2,"月结(次月前7个工作日内)"),
        PAYMENT_3(3,"以【备注】约定为准");
        private Integer code;
        private String msg;
        LastPaymentEnum(Integer code,String msg){
            this.code = code;
            this.msg = msg;
        }
        public static String get(Integer code){
            if(code == null){
                return "";
            }
            for(LastPaymentEnum lastPaymentEnum : values()){
                if(code.equals(lastPaymentEnum.getCode())){
                    return lastPaymentEnum.getMsg();
                }
            }
            return "";
        }
    }
}
