package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * `sign_entity`
 */
@Data
public class SignEntity implements Serializable {
    private static final long serialVersionUID = -4293985888180205247L;

    @ApiModelProperty("签约主体ID")
    private Long signEntityId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("1-个人，2-企业")
    private Byte entityType;

    @ApiModelProperty("0-正常，1-停用")
    private Byte entityStatus;

    @ApiModelProperty("实名状态，0-未实名，1-实名中，2-实名完成，3-实名被驳回")
    private Byte authStatus;

    @ApiModelProperty("名称, 企业名称或者个人名称")
    private String entityName;

    @ApiModelProperty("责任人")
    private Long userId;

    @ApiModelProperty("负责人名称")
    private String userName;

    @ApiModelProperty("手机号码")
    private String mobile;

    @ApiModelProperty("签章")
    private String seal;
}