package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.request.signature.CardAuthRequest;
import cn.com.duiba.youqian.center.api.request.user.ConfirmPerson2Request;
import cn.com.duiba.youqian.center.api.result.user.UserAuthVO;
import cn.com.duiba.youqian.center.api.result.user.UserIdentityVO;

/**
 * @author tengtuox
 * @date 2020/1/6
 * @description 员工/卖家
 */
@AdvancedFeignClient
public interface RemoteSignatureService {

    /**
     * 扫描证件
     * @param carReq
     * @return
     * @throws BizException
     */
    UserIdentityVO scanCard(CardAuthRequest carReq) throws BizException;

    /**
     * 发送合同编号
     * @param userId 用户ID
     * @param orderNo 订单编号
     * @return
     * @throws BizException
     */
    String sendContract(Long userId,String orderNo) throws BizException;

    /**
     * 认证三要素
     * @param userId 用户ID
     * @param name 姓名
     * @param idCard 身份证
     * @param code 验证码
     */
    UserAuthVO authCard_0(Long userId, String name, String idCard, String code) throws BizException;

    String authCard(Long userId, String name, String idCard, String code) throws BizException;

    /**
     * 扫描图片后--用户提交信息
     * @param confirmPerson2Request 操作用户的信息
     */
    void confirmCardInfo(ConfirmPerson2Request confirmPerson2Request) throws BizException;
}
