package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.PlatformUser;
import cn.com.duiba.youqian.center.api.entity.UserAddress;
import cn.com.duiba.youqian.center.api.request.user.PlatformUserRequest;
import cn.com.duiba.youqian.center.api.request.user.SearchUserRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 登陆校验
     *
     * @param account  account
     * @param password password
     * @return PlatformUser
     * @throws BizException 账号或密码不正确
     */
    PlatformUser login(String account, String password) throws BizException;

    /**
     * 根据Account查询User
     *
     * @param account account
     * @return PlatformUser
     */
    PlatformUser getByAccount(String account) throws BizException;

    /**
     * 根据UserId获取用户信息
     *
     * @param userId userId
     * @return PlatformUser
     * @throws BizException 用户不存在
     */
    PlatformUser get(Long userId) throws BizException;

    /**
     * 注册用户
     *
     * @param platformUser platformUser
     * @return userId
     * @throws BizException 用户已存在
     */
    Long register(PlatformUser platformUser) throws BizException;

    /**
     * 更新用户信息
     *
     * @param platformUser platformUser
     * @throws BizException 用户不存在
     */
    void update(PlatformUser platformUser) throws BizException;

    /**
     * 解绑微信
     *
     * @param userId userId
     */
    void unbindingWx(Long userId) throws BizException;

    /**
     * 搜索用户
     *
     * @param request request
     * @return PageResult<PlatformUser>
     */
    PageResult<PlatformUser> pageList(SearchUserRequest request) throws BizException;

    /**
     * 根据UserId获取用户信息
     *
     * @param openId openId
     * @return PlatformUser
     * @throws BizException 用户不存在
     */
    PlatformUserRequest getUserByOpenId(String openId) throws BizException;

    /**
     * 更新用户表微信的信息
     * @param openId 用户登录的openId
     * @param data 微信返回的信息
     */
    PlatformUserRequest updateUserWxInfoByOpenId(String openId, String data) throws BizException;

    /**
     * 查看用户是否认证
     * @param userId 当前登陆用户的ID
     */
    List<Integer> getUserAuthStatus(Long userId);

    /**
     * 添加地址
     *
     * @param userAddress userAddress
     * @return id
     */
    Long addUserAddress(UserAddress userAddress) throws BizException;

    /**
     * 根据用户ID获取地址列表
     *
     * @param userId userId
     * @return List<UserAddress>
     */
    List<UserAddress> getUserAddress(Long userId) throws BizException;

    /**
     * 删除用户地址
     *
     * @param id id
     */
    void deleteUserAddress(Long id) throws BizException;

    /**
     * 更新用户地址
     *
     * @param userAddress userAddress
     * @throws BizException 地址不存在
     */
    void updateUserAddress(UserAddress userAddress) throws BizException;

    /**
     * 获取UserAddress
     *
     * @param id id
     * @throws BizException 地址不存在
     */
    UserAddress getUserAddressById(Long id) throws BizException;

}
