package cn.com.duiba.youqian.center.api.result.order;

import cn.com.duiba.youqian.center.api.request.template.TemplateOtherFieldVO;
import cn.com.duiba.youqian.center.api.result.sign.BuyerSignVO;
import cn.com.duiba.youqian.center.api.result.sign.SellerSignVO;
import cn.com.duiba.youqian.center.api.result.template.TemplateValueVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class OrderDescVO implements Serializable {
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 开单人名字
     */
    private String createUserName;
    /**
     * 开单人手机号
     */
    private String createUserPhone;
    /**
     * 买方信息
     */
    private BuyerSignVO buyerSignVO;
    /**
     * 卖方信息
     */
    private SellerSignVO sellerSignVO;
    /**
     * 商品信息
     */
    List<OrderGoodsVO> orderGoodsDTO;
    /**
     * 总价格
     */
    private String countPrice;
    /**
     * 实际价格
     */
    private String totalPrice;
    /**
     * 是否卖家
     */
    private Boolean isMerchant;
    /**
     * 订单状态
     */
    private Integer orderStatus;
    /**
     * 合同信息
     */
    private String contract;
    /**
     * 实际价格
     */
    private String price;
    /**
     * 优惠价格
     */
    private String reducePrice;
    /**
     * 收货地址
     */
    private String receiveAddress;
    /**
     * 开单用户ID
     */
    private Long createUserId;
    /**
     * 收货人名字
     */
    private String receiveName;
    /**
     * 收货人手机号
     */
    private String receiveMobile;
    /**
     * 模板其他信息
     */
    private List<TemplateValueVO> templateValueVOS;

    @ApiModelProperty("是否是有签订单")
    private Boolean youqianOrder;

    private TemplateOtherFieldVO otherFields;

    private Integer transportWayIndex;

    private String deliveryAddress;

    private String otherDesc;
}
