package cn.com.duiba.youqian.center.api.result.template;

import cn.com.duiba.youqian.center.api.entity.TemplateField;
import cn.com.duiba.youqian.center.api.enums.TemplateFieldTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
public class TemplateFieldValueFVO extends TemplateField implements Serializable {
    private String[] preValueArray;

    private List<Integer> relevanceId;

    private String relevanceEvent;

    public TemplateFieldValueFVO conversion(TemplateField t, Map<Long,List<Integer>> buttonEvent){
        if(t.getFieldType().equals(TemplateFieldTypeEnum.SELECT.getCode())){
            this.preValueArray = StringUtils.isEmpty(t.getPreValue())?new String[0]:t.getPreValue().split(",");
        }
        this.setId(t.getId());
        this.setDisable(t.getDisable());
        this.setTemplateId(t.getTemplateId());
        this.setFieldCategory(t.getFieldCategory());
        this.setFieldName(t.getFieldName());
        this.setFieldType(t.getFieldType());
        this.setRequire(t.getRequire());
        this.setPlaceholder(t.getPlaceholder());
        this.setPreValue(t.getPreValue());
        this.setDefValue(t.getDefValue());
        this.setRelyOnFieldId(t.getRelyOnFieldId());
        if(t.getFieldType().equals(TemplateFieldTypeEnum.RICH_TEXT.getCode())){
            this.relevanceEvent = "false";
            this.relevanceId = buttonEvent.get(t.getId());
        }
        return this;
    }
}
