package cn.com.duiba.youqian.center.api.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * `order_user`
 */
@Data
public class OrderUser implements Serializable {
    @ApiModelProperty("订单参与人")
    private Long id;

    @ApiModelProperty("订单ID")
    private Long orderId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("参与人角色，1-发件人，2-卖家，3-买家，4-审批人，5-经办人")
    private Byte userType;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("账号")
    private String account;

    @ApiModelProperty("手机号码")
    private String mobile;

    @ApiModelProperty("主体ID")
    private Long signEntityId;

    @ApiModelProperty("主体类型，1-个人，2-企业")
    private Byte entityType;

    @ApiModelProperty("名称, 企业名称或者个人名称")
    private String entityName;

    @ApiModelProperty("企业名称")
    private String enterpriseName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("操作时间")
    private Date operationTime;
}