package cn.com.duiba.youqian.center.api.enums;

import lombok.Getter;

import java.math.BigDecimal;

@Getter
public enum InvoiceEnum {
    /**
     * 系统默认发票方案
     */
    DEFAULT_VALUE_ADD_INVOICE("-1","增值税专用发票","0.15",1),
    DEFAULT_NORMAL_INVOICE   ("-2" ,"普通发票","0.03",2);

    private String id;
    private String name;
    private String invoice;
    private Integer type;

    InvoiceEnum(String id,String name,String invoice,Integer type){
        this.id = id;
        this.name = name;
        this.invoice = invoice;
        this.type = type;
    }

    public static boolean get(Integer type,String invoice){
        for(InvoiceEnum invoiceEnum:values()){
            if(invoiceEnum.getType().equals(type) && invoiceEnum.getInvoice().equals(invoice)){
                return true;
            }
        }
        return false;
    }

    public static InvoiceEnum get(Integer type){
        for(InvoiceEnum invoiceEnum:values()){
            if(invoiceEnum.getType().equals(type)){
                return invoiceEnum;
            }
        }
        return null;
    }

    public static InvoiceEnum get(String id){
        for(InvoiceEnum invoiceEnum:values()){
            if(id.equals(invoiceEnum.getId())){
                return invoiceEnum;
            }
        }
        return null;
    }

    public static String getByTaxPointStr(String id){
        InvoiceEnum invoiceEnum = get(id);
        if(invoiceEnum != null) {
            return invoiceEnum.getName() + ",税点:" + new BigDecimal(invoiceEnum.getInvoice()).multiply(new BigDecimal(100)).setScale(0) + "%";
        }
        return null;
    }

    public static String getTaxPointById(String id){
        InvoiceEnum invoiceEnum = get(id);
        if(invoiceEnum != null) {
            return new BigDecimal(invoiceEnum.getInvoice()).multiply(new BigDecimal(100)).setScale(0) + "%";
        }
        return null;
    }

    public static String format(Integer type){
        InvoiceEnum invoiceEnum = get(type);
        return invoiceEnum.getName()+",税点:"+new BigDecimal(invoiceEnum.getInvoice()).multiply(new BigDecimal(100)).setScale(0)+"%";
    }
}
