package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.PayOrder;
import cn.com.duiba.youqian.center.api.result.order.PayOrderDetail;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemotePayOrderService {

    /**
     * 新增支付单
     *
     * @param payOrder payOrder
     * @return payOrderId
     */
    Long add(PayOrder payOrder) throws BizException;

    /**
     * 支付单详情
     *
     * @param merchantId merchantId
     * @param userId userId
     * @return PayOrderDetail
     */
    PayOrderDetail detail(Long merchantId, Long userId) throws BizException;

    /**
     * 支付单信息
     *
     * @param merchantId merchantId
     * @param userId userId
     * @return PayOrder
     * @throws BizException
     */
    PayOrder get(Long merchantId, Long userId) throws BizException;

}
