package cn.com.duiba.youqian.center.api.result.merchant;

import cn.com.duiba.youqian.center.api.entity.MerchantInvoice;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class MerchantInvoiceResult implements Serializable {
    private Integer type;

    private String taxPoint;

    private String id;

    public MerchantInvoiceResult conversion(MerchantInvoice merchantInvoice){
        this.type = merchantInvoice.getInvoiceType().intValue();
        this.id = merchantInvoice.getId().toString();
        this.taxPoint = merchantInvoice.getTaxPoint().multiply(new BigDecimal(100)).setScale(0)+"%";
        return this;
    }
}
