package cn.com.duiba.zhongyan.activity.service.api.param.export;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.checkerframework.checker.units.qual.Length;
import org.jetbrains.annotations.NotNull;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/20
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RemoteActivityPointExportRecordRequest extends RemoteExportRecordRequest {

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * openId
     */
    private String openId;

    /**
     * 手机号
     */
    private String phoneNum;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 最后参与时间开始时间 秒级时间戳
     */
    private Long participateStartTime;

    /**
     * 最后参与时间结束时间 秒级时间戳
     */
    private Long participateEndTime;

    /**
     * 排序字段名称
     */
    private String sortField;

    /**
     * 排序类型：1：正序 2：倒叙
     */
    private Integer sortType;
}
