package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityInfoDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityTypeDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.BaseConfigDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.JoinActivityPageDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.PrizeConfigDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.QueryActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.QueryAllActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.TemplateDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.ActivityPageParam;
import cn.com.duiba.zhongyan.activity.service.api.param.vote.ActivityEmbedVotePageParam;

import java.util.List;
import java.util.Map;

/**
 * @author xuanyu
 * @description: 活动对外服务
 * @date 2021/11/25 6:05 下午
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 根据id查询活动
     * @param id
     * @return
     */
    ActivityDTO selectById(Long id);

    /**
     * 插入一条数据
     * @param record
     * @return
     */
    Long save(ActivityDTO record);

    /**
     * 选择更新
     * @param record
     * @return
     */
    Boolean updateByIdSelective(ActivityDTO record);


    /**
     * 模版列表
     * @param pageRequest
     * @return
     */
    PageResponse<TemplateDTO> listPageTemplate(PageRequest pageRequest);

    /**
     * 分页查询活动
     * @param pageRequest
     * @return
     */
    PageResponse<ActivityDTO> listPageActivity(PageRequest pageRequest);

    /**
     * 根据条件参数查询活动
     * @param activityPageParam
     * @return
     * @throws BizException
     */
    PageResponse<ActivityDTO> listPageActivityByConditions(ActivityPageParam activityPageParam);

    /**
     * 根据条件参数查询活动：
     *  条件：只有按活动标题模糊查询
     *  返回：只有活动标题和活动id
     *
     * @param activityPageParam
     * @return
     * @throws BizException
     */
    PageResponse<ActivityDTO> listPageSimpleByConditions(ActivityPageParam activityPageParam);

    /**
     * 分页查询活动--参与活动
     * @param activityDTO
     * @return
     * @deprecated 这个是混合查询，请使用下面的统一查询
     */
    @Deprecated
    PageResponse<JoinActivityPageDTO> listJoinActivityPage(QueryActivityDTO activityDTO);

    PageResponse<JoinActivityPageDTO> listJoinActivityPageV2(QueryActivityDTO activityDTO);

    /**
     * 获取活动配置的奖品信息
     * @param activityId 活动id
     * @return 活动奖品配置
     */
    PrizeConfigDTO getPrizeConfig(Long activityId) throws BizException;

    /**
     * 获取问卷配置的题目数量
     * @param activityId 活动id
     * @return 活动奖品配置
     */
    Integer getQuestionCount(Long activityId) throws BizException;

    /**
     * 获取活动的基本配置
     * @param activityId
     * @return
     * @throws BizException
     */
    BaseConfigDTO getBaseConfig(Long activityId) throws BizException;

    /**
     * 查询活动类型
     * @return
     */
    List<String> listActType();

    /**
     * 根据活动ID批量查询活动
     * @param ids
     * @return
     */
    List<ActivityDTO> listActivityByIds(List<Long> ids);

    /**
     * 根据活动ID批量查询活动标题
     *
     * @param ids
     * @return
     */
    List<ActivityDTO> listTitleByIds(List<Long> ids);

    /**
     * 查询活动类型
     * @return
     */
    List<ActivityTypeDTO> listActivityType();

    /**
     * 本地库获取类型
     * @return
     */
    Map<String, String> getActivityTypeMap();
    /**
     * 自定义活动筛选
     *
     */
    PageResponse<ActivityInfoDTO> findActList(QueryAllActivityDTO queryAllActivityDTO);

    /**
     * 查询新表活动类型
     * @return
     */
    List<String> listAllActType();

    /**
     * 获取datav需要数据
     * @param templateType
     * @return
     */
    List<ActivityDTO> listDataVActivity(String  templateType);

    /**
     * 根据模板类型查找最近一场活动的活动id
     * @param templateType 模板类型
     * @return 活动id
     */
    Long getRecentActivityIdByType(String templateType);

    /**
     * 根据模板类型查找最近一场活动信息
     * @param templateType 模板类型
     * @return 活动id
     */
    ActivityDTO getRecentActivityByType(String templateType);

    /**
     * 根据投票活动id查询陈列竞赛活动
     * @param voteActivityId
     * @return
     */
    ActivityDTO getDisplayActivityByVoteId(Long voteActivityId);

    /**
     *  获取可嵌入的活动
     * @return
     */
    PageResponse<ActivityDTO> getEmbedVoteActivity(ActivityEmbedVotePageParam activityEmbedVotePageParam);

    /**
     * 投票活动关联陈列活动
     * @param voteActivityId
     * @param displayActivityId
     */
    void saveVoteLinkDisplayActivity(Long voteActivityId, Long displayActivityId);

    /**
     * 投票活动关联陈列活动
     * @param voteActivityId
     * @param displayActivityId
     */
    void updateVoteLinkDisplayActivity(Long voteActivityId, Long displayActivityId);

    /**
     * 根据模板类型查找活动
     * @param templateType 模板类型
     * @return 活动列表
     */
    List<ActivityDTO> getActivityByTemplateType(String templateType);


    /**
     * 投票活动关联陈列活动
     * @param voteActivityId
     */
    void deleteVoteLinkDisplayActivity(Long voteActivityId);

    /**
     * 根据绑定活动ID查询关联活动
     * @param activityId
     * @return
     */
    ActivityDTO getLinkActivityByBindId(Long activityId);

    /**
     * 判断活动是否被绑定
     * @param activityId
     * @return
     */
    Boolean judgeActivityIsBind(Long activityId);



}
