package cn.com.duiba.zhongyan.activity.service.api.remoteservice.invite;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.DoAssistDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.invite.DoAssistParam;
import cn.com.duiba.zhongyan.activity.service.api.param.invite.GenerateInviteCodeParam;
import cn.com.duiba.zhongyan.activity.service.api.param.invite.QueryCycleInviteCountParam;

/**
 * @author xuanyu
 * @description: 邀请玩法
 * @date 2022/7/14 12:31 PM
 */
@AdvancedFeignClient
public interface RemoteInviteService {

    /**
     * 生成邀请码
     * @param generateInviteCodeParam 生成邀请码参数
     * @return 邀请码
     */
    String generateInviteCode(GenerateInviteCodeParam generateInviteCodeParam) throws BizException;

    /**
     * 助力
     * @param doAssistParam 助力参数
     */
    DoAssistDTO doAssist(DoAssistParam doAssistParam) throws BizException;

    /**
     * 查询周期内用户已邀请人数
     * @param queryCycleInviteCountParam 查询参数
     * @return 查询用户已邀请人数
     * @throws BizException
     */
    Long queryCycleInviteCount(QueryCycleInviteCountParam queryCycleInviteCountParam) throws BizException;
}
