package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityReportCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityUserAccessDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.CountAccessActivityConditionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QueryAccessPageActivityParam;

import java.util.Date;
import java.util.List;

/**
 * @author xuanyu
 * @description: 查询用户首页访问记录
 * @date 2022/7/19 5:06 PM
 */
@AdvancedFeignClient
public interface RemoteActivityUserAccessService {
    /**
     * 插入一条记录
     * @param activityUserAccessDTO 记录
     * @return
     */
    int addActivityUserAccessData(ActivityUserAccessDTO activityUserAccessDTO);

    /**
     * 分页查询用户首页访问记录
     * @param queryAccessPageActivityParam 查询参数
     * @return 用户首页访问记录
     */
    PageResponse<ActivityUserAccessDTO> queryPageActivityUserAccess(QueryAccessPageActivityParam queryAccessPageActivityParam);

    /**
     * 按条件统计人数(已去重)
     * @param countAccessActivityConditionParam 查询条件
     * @return 去重人数
     */
    Long countActivityUserAccessByCondition(CountAccessActivityConditionParam countAccessActivityConditionParam);

    /**
     * 查询指定时间段范围内独立访客(用户未读去重数据)
     * @param activityId 活动id
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return
     */
    List<ActivityReportCountDTO> getTimePeriodUserViewCount(Long activityId, Date startDate, Date endDate);
}
