package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.PageResult;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.BackPrizeCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinnerRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.*;

import java.util.Date;
import java.util.List;

/**
 * @author xuanyu
 * @description: 用户中奖记录表对外服务
 * @date 2021/11/25 5:57 下午
 */
@AdvancedFeignClient
public interface RemoteUserPrizeRecordService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id) throws BizException;

    /**
     * 根据实体插入一条用户中奖记录
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 主键id
     */
    Long insert(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 选择性插入实体中不为null的属性
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 主键id
     */
    Long insertSelective(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条用户中奖记录
     */
    UserPrizeRecordDTO selectByPrimaryKey(Long id) throws BizException;

    /**
     * 选择性更新实体中不为null的值
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据主键id更新
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据查询参数返回中奖记录(含奖品名）,可补充返回奖品表的DTO
     * @param pageQueryParam 查询参数
     * @return
     */
    PageResult<UserPrizeRecordDTO> listUserPrizeRecordEntity(UserPrizeRecordPageQueryParam pageQueryParam) throws BizException;



    /**
     * 分页查询奖品列表
     * @param prizeConditionParam
     * @return
     */
    PageResult<UserPrizeDTO> listWinPrizePageByConditions(PrizeConditionParam prizeConditionParam);

    /**
     * 条件分页查询用户中奖记录
     * @param userPrizeRecordPageQueryParam 用户中奖记录(含用户，奖品关联筛选）
     * @return 用户中奖记录
     */
    PageResult<WinnerRecordDTO> listUserPrizeRecordWithUser(UserPrizeRecordPageQueryParam userPrizeRecordPageQueryParam) throws BizException;

    /**
     *
     * @param userPrizeRecordPageQueryParam
     * @return
     * @throws BizException
     */
    Integer countUserPrizeRecordWithUser(UserPrizeRecordPageQueryParam userPrizeRecordPageQueryParam) throws BizException;

    /**
     * 更新未确认状态的中奖记录未已确认
     * @return 操作成功的条数
     */
    Integer confirmPrizeRecord(Long activityId) throws BizException;

    List<UserPrizeRecordDTO> listUserPrizeByUser(Long activityId, Long userId) throws BizException;


    /**
     * 根据用户id和活动id更新中奖记录
     * @param userPrizeRecordDTO
     * @return
     */
    int updateByUserIdAndActivityIdSelective(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据中奖记录id删除未确认状态的中奖记录
     * @param prizeRecordId 中奖记录id
     * @return 操作成功的条数
     */
    Integer deleteByPrimaryKeyAndStatus(Long prizeRecordId) throws BizException;

    /**
     * 根据活动id和userIdList批量查询用户中奖记录
     * @param activityId 活动id
     * @param userIdList 用户列表
     * @return 用户中奖记录
     */
    List<UserPrizeRecordDTO> listUserPrizeByUserIds(Long activityId,List<Long> userIdList) throws BizException;

    /**
     * 添加用户中奖记录
     * @param addWinnerRecordParam 添加中奖记录
     * @return 添加中奖记录
     */
    Boolean addWinnerPrizeRecord(AddWinnerRecordParam addWinnerRecordParam) throws BizException;

    /**
     * 批量查询用户中奖记录
     * @param userPrizeRecordDTOList 用户中奖记录
     * @return
     */
    Integer insertBatchUserRecord(List<UserPrizeRecordDTO> userPrizeRecordDTOList) throws BizException;

    /**
     * 根据条件参数查询记录
     * @param userPrizeRecordConditionParam
     * @return 中奖记录
     */
    List<UserPrizeRecordDTO> listUserPrizeRecordByCondition(UserPrizeRecordConditionParam userPrizeRecordConditionParam) throws BizException;

    /**
     * 根据条件获取双
     * @param userPrizeRecordConditionParam 条件参数
     * @return 数量
     */
    Integer countUserPrizeRecordByCondition(UserPrizeRecordConditionParam userPrizeRecordConditionParam) throws BizException;

    /**
     * 获取奖品回退数量
     * @param backPrizeStockParam
     * @return
     */
    List<BackPrizeCountDTO> groupAndGetBackPrizeCount(BackPrizeStockParam backPrizeStockParam) throws BizException;

    /**
     * 统计分组数量
     * @param backPrizeStockParam
     * @return
     */
    Integer countGroupGetBackPrize(BackPrizeStockParam backPrizeStockParam) throws BizException;

    /**
     * 根据活动id 奖品id 失效时间更新中奖记录状态
     * @param activityId 活动id
     * @param prizeId 奖品id
     * @param expireTime 失效时间
     * @return
     */
    Integer updateStatusByActivityAndPrizeId(Long activityId, Long prizeId, Date expireTime, Byte prizeStatus) throws BizException;

    /**
     * 发奖参数
     * @param sendPrizeParam 发奖参数
     * @return 为true 发奖成功，为false发奖失败
     */
    Boolean sendPrize(SendPrizeParam sendPrizeParam) throws BizException;

    /**
     * 逻辑删除中奖记录
     * @param userPrizeRecordDTO
     * @return
     * @throws BizException
     */
    Boolean deleteRecord(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 更新中奖记录状态
     * @param updateStatusAndBackStockParam
     * @return
     * @throws BizException
     */
    Boolean updateStatusAndBackActivityStock(UpdateStatusAndBackStockParam updateStatusAndBackStockParam) throws BizException ;

    /**
     * 回退库存
     * @param backPrizeStockParam
     * @param expireDate
     * @return
     */
    Boolean backPrizeStock(BackPrizeStockParam backPrizeStockParam,Date expireDate) throws BizException ;
}
