package cn.com.duiba.zhongyan.activity.service.api.enums;

/**
 * @author LuHui
 * @description
 * @date 2021/11/25  16:30
 */
public enum ErrorCodeEnum implements BizError {

    PARAM_ERROR(100100, "参数错误"),
    ACTIVITY_NOT_EXIT(100101, "该活动不存在"),
    ACTIVITY_NOT_START(100102, "活动尚未开始"),
    ACTIVITY_ALREADY_END(100103, "活动已结束"),
    ANSWER_VERITY_AREA(100104, "仅限部门地区可参与"),
    ANSWER_VERIFY_USER(100105, "该活动仅限零售户参与"),
    ANSWER_VERITY(100106, "请先完成当前题目"),
    ANSWER_RECORD_NOT_EXIT(100107, "答题记录不存在"),
    ANSWER_NOT_COMMIT(100108, ""),
    USER_NOT_EXIT(100109,"用户不存在"),
    USER_NOT_SUBSCRIBE(100110,"用户未关注"),
    LIMIT_DRAW_TIME_DAY(100111,"抽奖次数达到每日上限"),
    POINT_NOT_ENOUGH(100112,"积分不足"),
    POINT_NOT_IN_CONDITION(100113,"不可中奖时段或者不可中奖地市"),
    POINT_BLACK(100114,"黑名单"),
    POINT_GOODS_REPERTORY_NOT_ENOUGH(100115,"奖品库存不足"),
    POINT_WIN_TIME_LIMIT(100116,"中奖总次数达到上限"),
    POINT_GOODS_WIN_TIME_LIMIT(100117,"抽中的奖品达到单奖品上限"),
    POINT_GOODS_EXCHANGE_TIME_LIMIT(100118,"是否超过同款奖品限兑次数"),

    NOT_OPERATION(200100, "无法操作"),
    NOT_ACQUIRE_LOCK(200101, "获取锁失败"),
    CAN_VIEW_ANSWER(200102,"查看答卷"),
    ANSWER_NOT_EMPTY(200103, "答案不能为空"),
    OPTION_NOT_EXIT(200104, "无此选项"),
    REQUIRED_MUST_FILL(200105,"该选项必填框必填"),
    ACTIVITY_END_VIEW_ANSWER(200106, "活动已结束，可以查看提交过的问卷问题及答案"),
    ACTIVITY_END_NOT_VIEW_ANSWER(200207, "活动已结束，无查看问卷链接"),

    NOT_ACQUIRE_PRIZE(300100, "该奖品无法被领取"),
    ALREADY_ACQUIRE_PRIZE(300101, "该奖品已被领取"),
    CREATE_ORDER_FAIL(300102, "创建订单失败"),


    ACTIVITY_USER_RECORD_NOT_NULL(400100, "参与记录不能为空"),
    ACTIVITY_USER_RECORD_DATA_SOURCE_TYPE_NOT_NULL(400101, "参与记录数据来源不能为空"),
    ACTIVITY_USER_RECORD_ACTIVITY_ID_NOT_NULL(400102, "参与记录活动id不能为空"),
    ACTIVITY_USER_RECORD_DATA_SOURCE_ID_NOT_NULL(400103, "参与记录数据来源id"),
    ACTIVITY_USER_RECORD_OPEN_ID_NOT_NULL(400104, "参与记录用户openId不能为空"),
    ACTIVITY_USER_RECORD_ACTIVITY_TITLE_NOT_NULL(400105, "参与记录用户活动名称不能为空"),
    ACTIVITY_USER_RECORD_JOIN_TIME_NOT_NULL(400106, "参与记录用户参与时间不能为空"),
    ACTIVITY_USER_RECORD_ACQUIRE_PRIZE_NOT_NULL(400107, "参与记录用户是否中奖不能为空"),


    SUCCESS(20000, "成功"),
    ERROR(20001,"内部错误");






    ErrorCodeEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private int code;
    private String message;

    @Override
    public int errorCode() {
        return code;
    }

    @Override
    public String errorMessage() {
        return message;
    }
}
