package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 活动参与记录表(TbActivityUserRecord)实体类
 *
 * @author makejava
 * @since 2021-12-27 13:39:17
 */
@Getter
@Setter
public class ActivityUserRecordDTO implements Serializable {
    private static final long serialVersionUID = 343468483331515437L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * open_id
     */
    private String openId;
    /**
     * 活动名称
     */
    private String activityTitle;
    /**
     * 活动Id
     */
    private String activityId;
    /**
     * 活动类型,允许多个["01","02"]
     */
    private String activityType;
    /**
     * 参与时间
     */
    private Date joinTime;
    /**
     * 是否中奖 0:未中奖 1:已中奖
     */
    private Integer acquirePrize;
    /**
     * 数据来源:0:自有数据 1:老兑吧数据 2:周力
     */
    private Integer dataSourceType;

    private Extra extra;

    private String imageUrl;

//    private String orderNo;

    private Date startTime;

    private Date endTime;

    private Integer prizeStatus;

    private Long dataSourceId;

    @Getter
    @Setter
    public static class Extra implements Serializable{
        private List<Order> order;
    }
    @Getter
    @Setter
    public static class Order implements Serializable{
        private String orderNo;
        private String logisticsNo;
        private String logisticsName;

        private List<Product> product;
    }
    @Getter
    @Setter
    public static class Product implements Serializable{
        private  String image;
        private  String name;
    }

}

