package cn.com.duiba.zhongyan.activity.service.api.base;

import cn.com.duiba.zhongyan.activity.service.api.enums.ErrorCodeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author xuanyu
 * @description: 返回类型
 * @date 2021/11/26 2:04 下午
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServiceResponse<T> implements Serializable {
    private static final long serialVersionUID = -4013056288290917503L;

    /**
     * 返回码
     */
    private Integer code;

    /**
     * 信息
     */
    private String message;

    /**
     * 执行状态
     */
    private Boolean success;

    /**
     * 数据
     */
    private T data;

    public static <T> ServiceResponse<T> success(T data){
        ServiceResponse<T> response = new ServiceResponse<>();
        response.setSuccess(Boolean.TRUE);
        response.setCode(ErrorCodeEnum.SUCCESS.errorCode());
        response.setData(data);
        response.setMessage(ErrorCodeEnum.SUCCESS.errorMessage());
        return response;
    }

    public static <T> ServiceResponse<T> fail(T data){
        ServiceResponse<T> response = new ServiceResponse<>();
        response.setSuccess(Boolean.FALSE);
        response.setCode(ErrorCodeEnum.ERROR.errorCode());
        response.setData(data);
        response.setMessage(ErrorCodeEnum.ERROR.errorMessage());
        return response;
    }
}
