package cn.com.duiba.zhongyan.activity.service.api.enums;

/**
 * @author LuHui
 * @description
 * @date 2021/11/25  16:30
 */
public enum ErrorCodeEnum implements BizError {

    PARAM_ERROR(100100, "参数错误"),
    ACTIVITY_NOT_EXIT(100101, "该活动不存在"),
    ACTIVITY_NOT_START(100102, "活动未开始"),
    ACTIVITY_ALREADY_END(100103, "活动已结束"),
    ANSWER_VERITY_AREA(100104, "仅限部门地区可参与"),
    ANSWER_VERIFY_USER(100105, "该活动仅限零售户参与"),
    ANSWER_VERITY(100106, "请先完成当前题目"),
    ANSWER_RECORD_NOT_EXIT(100107, "答题记录不存在"),
    ANSWER_NOT_COMMIT(100108, "无法重复提交答卷"),
    SUCCESS(20000, "成功"),
    ERROR(20001,"内部错误");






    ErrorCodeEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private int code;
    private String message;

    @Override
    public int errorCode() {
        return code;
    }

    @Override
    public String errorMessage() {
        return message;
    }
}
