package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDTO;

/**
 * @author xuanyu
 * @description: 活动对外服务
 * @date 2021/11/25 6:05 下午
 */
@AdvancedFeignClient
public interface RemoteActivityService {
    /**
     * 更改活动的状态
     * @param activityId 活动id
     * @return true
     */
    Boolean updateStatusByActivityId(String activityId);

    /**
     * 根据实体插入一条活动信息
     * @param activityDTO 活动信息
     * @return 主键id
     */
    Long insert(ActivityDTO activityDTO);


    /**
     * 根据活动id查找记录
     * @param activityId 活动id
     * @return 一条活动信息
     */
    ActivityDTO selectByActivityId(String activityId);


    /**
     * 更新活动信息
     * @param activityId 活动id
     * @return true
     */
    Boolean updateByActivityId(ActivityDTO activityDTO, String activityId);
}
