package cn.com.duiba.zhongyan.activity.service.api.remoteservice.survey;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.ServiceResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.AnswerRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.MatchConditionUserIdPram;

import java.util.List;
import java.util.Map;

/**
 * @author xuanyu
 * @description: 答题记录对外服务
 * @date 2021/11/25 6:03 下午
 */
@AdvancedFeignClient
public interface RemoteAnswerRecordService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id);

    /**
     * 根据实体插入一条答题记录
     * @param answerRecordDTO 答题记录
     * @return 主键id
     */
    Long insert(AnswerRecordDTO answerRecordDTO);

    /**
     * 选择性插入实体中不为null的属性
     * @param answerRecordDTO 答题记录
     * @return 主键id
     */
    Long insertSelective(AnswerRecordDTO answerRecordDTO);

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条答题记录
     */
    AnswerRecordDTO selectByPrimaryKey(Long id);

    /**
     * 选择性更新实体中不为null的值
     * @param answerRecordDTO 答题记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(AnswerRecordDTO answerRecordDTO);

    /**
     * 根据主键id更新
     * @param answerRecordDTO 答题记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(AnswerRecordDTO answerRecordDTO);


    /**
     * 根据实体批量插入答题记录
     * @param answerRecordDTO 答题记录
     * @return
     */
    int batchInsert(List<AnswerRecordDTO> answerRecordDTO);

    /**
     * 查询满足条件的用户
     * @param matchConditionUserIdPram 答题记录条件 与关系
     * @return 满足条件的userId列表
     */
    ServiceResponse<List<Long>> listMatchConditionUserIds(MatchConditionUserIdPram matchConditionUserIdPram);


}
