package cn.com.duiba.zhongyan.activity.service.api.base;

import cn.com.duiba.wolf.redis.RedisLock;

import java.util.concurrent.TimeUnit;

public interface RedisAtomicClientService {

    /**
     * 获取一个锁
     * 注：获得的锁对象（如果为null表示获取锁失败），后续可以调用该对象的unlock方法来释放锁
     *
     * @param key KEY
     * @param expireSeconds 失效时间
     * @return 锁对象
     */
    public RedisLock getLock(final String key, long expireSeconds);

    /**
     * 获取redis的分布式锁
     * @param key
     * @param expireSeconds
     * @param maxRetryTimes
     * @param retryIntervalTimeMillis
     * @return
     */
    public RedisLock getLock(final String key, final long expireSeconds, int maxRetryTimes, long retryIntervalTimeMillis);

    /**
     * 计数器
     *
     * @param key KEY
     * @param delta 计数
     * @param timeout 失效时间
     * @param timeUnit 时间单位
     * @return 当前结果
     */
    public Long incrBy(String key, long delta, long timeout, TimeUnit timeUnit);

    /**
     * get value
     * @param key
     * @return
     */
    public Long getAtomicValue(String key);
}