package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import cn.com.duiba.zhongyan.activity.service.api.enums.PrizeStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuanyu
 * @description: 中奖记录DTO
 * @date 2021/11/25 5:45 下午
 */
@Data
public class UserPrizeRecordDTO implements Serializable {

    private static final long serialVersionUID = 1500133100897583491L;

    /**
     * id
     */
    private Long id;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 奖品id
     */
    private Long prizeId;

    /**
     * prizeName 目前仅listUserPrizeRecordEntity方法返回
     */
    private String prizeName;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * @see PrizeStatusEnum
     * 中奖状态
     */
    private Byte prizeStatus;

    /**
     * 领取时间 秒级时间戳
     */
    private Long receiveTime;

    /**
     * 确认时间 秒级时间戳
     */
    private Long confirmTime;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;

    /**
     * 活动配置
     */
    private String attributes;

    /**
     * 有效期
     */
    private Date expireTime;

    /**
     * 规格
     */
    private String specification;
}
