package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.ServiceResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDetailDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityRulePrizeDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.AddWinnerRecordParam;

import java.util.List;

/**
 * @author xuanyu
 * @description:
 * @date 2021/11/25 6:08 下午
 */
@AdvancedFeignClient
public interface RemoteActivityRulePrizeService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id);

    /**
     * 根据实体插入一条活动奖品
     * @param activityRulePrizeDTO 活动奖品
     * @return 主键id
     */
    Long insert(ActivityRulePrizeDTO activityRulePrizeDTO);

    /**
     * 选择性插入实体中不为null的属性
     * @param activityRulePrizeDTO 活动奖品
     * @return 主键id
     */
    Long insertSelective(ActivityRulePrizeDTO activityRulePrizeDTO);

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条活动奖品
     */
    ActivityRulePrizeDTO selectByPrimaryKey(Long id);

    /**
     * 选择性更新实体中不为null的值
     * @param activityRulePrizeDTO 活动奖品
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(ActivityRulePrizeDTO activityRulePrizeDTO);

    /**
     * 根据主键id更新
     * @param activityRulePrizeDTO 活动奖品
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(ActivityRulePrizeDTO activityRulePrizeDTO);

    /**
     * 根据活动id查询活动下的奖品列表
     * @param activityId 活动id
     * @return 活动奖品列表
     */
    List<ActivityRulePrizeDTO> listActivityRulePrizeByActivityId(Long activityId) throws BizException;

    /**
     * 添加用户中奖记录
     * @param addWinnerRecordParam 添加中奖记录
     * @return 添加中奖记录
     */
    Boolean addWinnerPrizeRecord(AddWinnerRecordParam addWinnerRecordParam) throws BizException;

    /**
     * 批量查询用户中奖记录
     * @param userPrizeRecordDTOList 用户中奖记录
     * @return
     */
    Integer insertBatchUserRecord(List<UserPrizeRecordDTO> userPrizeRecordDTOList) throws BizException;

    /**
     * 更新已使用库存
     * @param rulePrizeDTO
     * @param offset 偏移量
     * @return
     */
    Integer updateStockByIdAndActivityId(ActivityRulePrizeDTO rulePrizeDTO,Integer offset) throws BizException;

}
