package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;

public interface StatisticsConfig {

    /**
     * 访问uv总量key-活动纬度
     */
    String TOTAL_VISIT_UV = "total_visit_uv_%s";
    static String getTotalVisitUv() {
        return TOTAL_VISIT_UV;
    }

    /**
     * 每日访问uv量key-活动纬度
     */
    String DAY_VISIT_UV = "day_visit_uv_%s";
    static String getDayVisitUv() {
        int dayNumber = DateUtils.getDayNumber(new Date());
        return String.format(DAY_VISIT_UV, dayNumber);
    }

    /**
     * 限制单个用户访问量key
     */
    String VISIT_UV = "visit_uv_%s";
    static String getVisitUv(Long userId) {
        return String.format(DAY_VISIT_UV, userId);
    }

    /**
     * 访问uv总量key-活动纬度
     */
    String TOTAL_VISIT_PV = "total_visit_pv_%s";
    static String getTotalVisitPv() {
        return TOTAL_VISIT_PV;
    }

    /**
     * 每日访问pv量key-活动纬度
     */
    String DAY_VISIT_PV = "day_visit_pv_%s";
    static String getDayVisitPv() {
        int dayNumber = DateUtils.getDayNumber(new Date());
        return String.format(DAY_VISIT_PV, dayNumber);
    }

    /**
     * 参与uv总量key-活动纬度
     */
    String TOTAL_JOIN_UV = "total_join_uv_%s";
    static String getTotalJoinUv() {
        return TOTAL_JOIN_UV;
    }

    /**
     * 每日参与uv量key-活动纬度
     */
    String DAY_JOIN_UV = "day_join_uv_%s";
    static String getDayJoinUv() {
        int dayNumber = DateUtils.getDayNumber(new Date());
        return String.format(DAY_JOIN_UV, dayNumber);
    }

    /**
     * 参与uv
     */
    String JOIN_UV = "join_uv_%s";
    static String getJoinUv(Long userId){
        return String.format(JOIN_UV, userId);
    }


    /**
     * 参与pv总量key-活动纬度
     */
    String TOTAL_JOIN_PV = "total_join_pv_%s";
    static String getTotalJoinPv() {
        return TOTAL_JOIN_PV;
    }

    /**
     * 每日参与pv量key-活动纬度
     */
    String DAY_JOIN_PV = "day_join_pv_%s";
    static String getDayJoinPv() {
        int dayNumber = DateUtils.getDayNumber(new Date());
        return String.format(DAY_JOIN_PV, dayNumber);
    }
    /**
     * 提交答卷
     */
    String SUBMIT_ANSWER = "statistics_submit_answer_%s";

    static String getSubmitAnswer(Long userId){
        return String.format(SUBMIT_ANSWER, userId);
    }
}
