package cn.com.duiba.zhongyan.activity.service.api.utils;

import cn.com.duiba.zhongyan.activity.service.api.base.BizRuntimeException;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinPrizeHeadExcelDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinnerRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerPageParam;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerPageRecordParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.metadata.Table;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ExcelExportUtil {

    public static final Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);

    public static final String outPath = "";

    //表头字段
    public static final List<String> answerPageHeadList = new ArrayList<String>() {
        {
            add("OpenID");
            add("UnionID");
            add("用户昵称");
            add("答题时间");
            add("所属地区");
            add("用户标签");
            add("答题时长");
        }
    };

    /**
     * 答卷导出
     *
     * @param answerPageRecordParamList
     * @param fileName
     * @throws Exception
     */
    public static void exportAnswerPage(List<AnswerPageRecordParam> answerPageRecordParamList, String fileName) {

        if (CollectionUtils.isEmpty(answerPageRecordParamList)) {
            throw new BizRuntimeException("没有数据导出");
        }
        OutputStream outputStream = null;
        ExcelWriter writer = null;
        try {
            outputStream = new FileOutputStream(outPath + fileName);
            writer = EasyExcelFactory.getWriter(outputStream);
            // 表单
            Sheet sheet = new Sheet(1, 0);
            sheet.setSheetName("sheet1");
            // 创建一个表格
            Table table = new Table(1);

            List<Integer> questionNum = answerPageRecordParamList.stream().map(answerPage -> {
                AnswerPageParam answerPageParam = JSONObject.parseObject(answerPage.getAnswerContent(), AnswerPageParam.class);
                return answerPageParam.getQuestionList().size();
            }).collect(Collectors.toList());
            //最大题目数
            Integer max = Collections.max(questionNum);

            for (int i = 1; i <= max; i++) {
                answerPageHeadList.add(String.format("题目%s", i));
                answerPageHeadList.add(String.format("答案%s", i));
            }

            //所有表头行集合
            ArrayList<List<String>> headList = new ArrayList<>();
            headList.add(answerPageHeadList);

            //行数据
            List<List<Object>> list = answerPageRecordParamList.stream().map(answerPageRecord -> {
                List<Object> row = new ArrayList<Object>();
                row.add(answerPageRecord.getOpenId());
                row.add(answerPageRecord.getUnionId());
                row.add(answerPageRecord.getNick());
                row.add(answerPageRecord.getAnswerTime());
                row.add(answerPageRecord.getRegion());
                row.add(answerPageRecord.getAvatar());
                row.add(answerPageRecord.getAnswerDuration());
                AnswerPageParam answerPage = JSONObject.parseObject(answerPageRecord.getAnswerContent(), AnswerPageParam.class);
                //题目
                List<QuestionAnswerParam> questionList = answerPage.getQuestionList();
                questionList.forEach(question -> {
                    row.add(question.getTitle());
                    //答案
                    String answer = question.getAnswerList().stream().map(answerContent -> {
                        //选择题
                        if (question.getType() != 2) {
                            //选择题答案
                            if (StringUtils.isBlank(answerContent.getRequiredAnswer())) {
                                return answerContent.getAnswer();
                            }
                            //选择答案+必填框答案
                            return String.format(answerContent.getAnswer() + "-%s", answerContent.getRequiredAnswer());
                        }
                        //填空题答案
                        return answerContent.getAnswer();

                    }).collect(Collectors.joining(";"));
                    row.add(answer);
                });
                return row;
            }).collect(Collectors.toList());

            table.setHead(headList);
            writer.write1(list, sheet, table);
            logger.info("数据导出成功:{}", outPath + fileName);
        } catch (FileNotFoundException e) {
            logger.error("找不到文件或文件路径错误, 文件：{}", outPath + fileName);
        }finally {
            try {
                if (writer != null) {
                    writer.finish();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            } catch (IOException e) {
                logger.error("excel文件导出失败, 失败原因：{}", e);
            }
        }
    }

    /**
     * 中奖用户导出
     *
     * @param winnerRecordDtoList
     * @param fileName
     */
    public static void winPrizeUserExport(List<WinnerRecordDTO> winnerRecordDtoList, String fileName) {
        if (CollectionUtils.isEmpty(winnerRecordDtoList)) {
            throw new BizRuntimeException("没有数据导出");
        }

        List<WinPrizeHeadExcelDTO> data = new ArrayList<>();
        winnerRecordDtoList.forEach(prize -> {
            WinPrizeHeadExcelDTO winPrizeHeadExcelDTO = new WinPrizeHeadExcelDTO();
            winPrizeHeadExcelDTO.setOpenId(prize.getOpenId());
            winPrizeHeadExcelDTO.setUnionID(prize.getUnionId());
            winPrizeHeadExcelDTO.setNick(prize.getNickName());
            winPrizeHeadExcelDTO.setPrize(prize.getPrizeName());
            winPrizeHeadExcelDTO.setPrizeStatus("");
            winPrizeHeadExcelDTO.setReceiveTime(prize.getReceiveTime());
            winPrizeHeadExcelDTO.setOrderId(prize.getOrderId().toString());
            winPrizeHeadExcelDTO.setUsername(prize.getUsername());
            winPrizeHeadExcelDTO.setPhone(prize.getPhone());
            winPrizeHeadExcelDTO.setAddress(prize.getAddress());
            data.add(winPrizeHeadExcelDTO);
        });
        writeWithTemplateAndSheet(fileName, data, null);
    }


    public static void writeWithTemplateAndSheet(String fileName, List<? extends BaseRowModel> data, Sheet sheet) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }

        sheet = (sheet != null) ? sheet : new Sheet(0, 1);
        sheet.setClazz(data.get(0).getClass());

        OutputStream outputStream = null;
        ExcelWriter writer = null;
        try {
            outputStream = new FileOutputStream(outPath + fileName);
            writer = EasyExcelFactory.getWriter(outputStream);
            writer.write(data, sheet);
        } catch (FileNotFoundException e) {
            logger.error("找不到文件或文件路径错误, 文件：{}", outPath + fileName);
        } finally {
            try {
                if (writer != null) {
                    writer.finish();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            } catch (IOException e) {
                logger.error("excel文件导出失败, 失败原因：{}", e);
            }
        }
    }


}
