package cn.com.duiba.zhongyan.activity.service.api.param;

import cn.com.duiba.zhongyan.activity.service.api.base.BasePageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuanyu
 * @description: 答卷查询参数
 * @date 2021/11/26 10:24 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AnswerPageQueryParam extends BasePageParam implements Serializable {

    private static final long serialVersionUID = 6751148507673658274L;

    /**
     * id
     */
    private Long id;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * openId
     */
    private String openId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 用户昵称
     */
    private String nick;

    /**
     * 答题开始时间 秒级时间戳
     */
    private Long startTime;

    /**
     * 答题结束时间 秒级时间戳
     */
    private Long endTime;

    /**
     * 答题时长起始
     */
    private Long longTimeStart;

    /**
     * 答题时长起始
     */
    private Long longTimeEnd;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;
}
