package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.ServiceResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDetailDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityRulePrizeDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.AddWinnerRecordParam;

import java.util.List;

/**
 * @author xuanyu
 * @description:
 * @date 2021/11/25 6:08 下午
 */
@AdvancedFeignClient
public interface RemoteActivityRulePrizeService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id);

    /**
     * 根据实体插入一条活动奖品
     * @param activityRulePrizeDTO 活动奖品
     * @return 主键id
     */
    Long insert(ActivityRulePrizeDTO activityRulePrizeDTO) throws BizException;

    /**
     * 选择性插入实体中不为null的属性
     * @param activityRulePrizeDTO 活动奖品
     * @return 主键id
     */
    Long insertSelective(ActivityRulePrizeDTO activityRulePrizeDTO) throws BizException;

    /**
     * 进行批量插入数据
     * @param activityRulePrizeDTOS 活动奖品列表list
     * @return
     */
    Long insertBatchActivityPrize(List<ActivityRulePrizeDTO> activityRulePrizeDTOS) throws BizException;

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条活动奖品
     */
    ActivityRulePrizeDTO selectByPrimaryKey(Long id) throws BizException;

    /**
     * 选择性更新实体中不为null的值
     * @param activityRulePrizeDTO 活动奖品
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(ActivityRulePrizeDTO activityRulePrizeDTO) throws BizException;

    /**
     * 根据主键id更新
     * @param activityRulePrizeDTO 活动奖品
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(ActivityRulePrizeDTO activityRulePrizeDTO) throws BizException;

    /**
     * 根据活动id查询活动下的奖品列表
     * @param activityId 活动id
     * @return 活动奖品列表
     */
    List<ActivityRulePrizeDTO> listActivityRulePrizeByActivityId(Long activityId) throws BizException;

    /**
     * 更新已使用库存
     * @param rulePrizeDTO
     * @param offset 偏移量
     * @return
     */
    Integer updateStockByIdAndActivityId(ActivityRulePrizeDTO rulePrizeDTO,Integer offset) throws BizException;

}
