/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.utils;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.zhongyan.activity.service.api.base.BizRuntimeException;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDetailExcelDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.SurveyDataExcelDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinPrizeHeadExcelDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinnerRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerPageParam;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerPageRecordParam;
import cn.com.duiba.zhongyan.activity.service.api.param.DataStatisticsParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.SurveyDataParam;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONObject;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtil {
    public static final Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);
    public static final String outPath = "";
    public static ExcelWriter writer = null;
    public static WriteSheet writeSheet = null;
    public static OutputStream outputStream = null;
    public static final List<String> answerPageHeadList = new ArrayList<String>(){
        {
            this.add("OpenID");
            this.add("UnionID");
            this.add("\u7528\u6237\u6635\u79f0");
            this.add("\u7b54\u9898\u65f6\u95f4");
            this.add("\u6240\u5c5e\u5730\u533a");
            this.add("\u7528\u6237\u6807\u7b7e");
            this.add("\u7b54\u9898\u65f6\u957f");
        }
    };

    public static void initAnswerExport(List<AnswerPageRecordParam> answerPageRecordParamList, OutputStream out) {
        outputStream = out;
        List questionNum = answerPageRecordParamList.stream().map(answerPage -> {
            AnswerPageParam answerPageParam = (AnswerPageParam)JSONObject.parseObject((String)answerPage.getAnswerContent(), AnswerPageParam.class);
            return answerPageParam.getQuestionList().size();
        }).collect(Collectors.toList());
        Integer max = (Integer)Collections.max(questionNum);
        for (int i = 1; i <= max; ++i) {
            answerPageHeadList.add(String.format("\u9898\u76ee%s", i));
            answerPageHeadList.add(String.format("\u7b54\u6848%s", i));
        }
        ArrayList<List<String>> headList = new ArrayList<List<String>>();
        headList.add(answerPageHeadList);
        writer = EasyExcelFactory.write((OutputStream)outputStream).head(headList).build();
        writeSheet = EasyExcelFactory.writerSheet((String)"\u4e2d\u5956\u8bb0\u5f55").build();
    }

    public static void close() {
        try {
            if (Objects.nonNull(writer)) {
                writer.finish();
            }
            if (Objects.nonNull(outputStream)) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }

    public static void exportAnswerPage(List<AnswerPageRecordParam> answerPageRecordParamList) throws Exception {
        if (CollectionUtils.isEmpty(answerPageRecordParamList)) {
            logger.info("\u65e0\u6570\u636e\u6216\u6570\u636e\u5bfc\u51fa\u5b8c\u6bd5");
            return;
        }
        List list = answerPageRecordParamList.stream().map(answerPageRecord -> {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(answerPageRecord.getOpenId());
            row.add(answerPageRecord.getUnionId());
            row.add(answerPageRecord.getNick());
            row.add(answerPageRecord.getAnswerTime());
            row.add(answerPageRecord.getRegion());
            row.add(answerPageRecord.getUserTagStr());
            row.add(answerPageRecord.getAnswerDuration());
            AnswerPageParam answerPage = (AnswerPageParam)JSONObject.parseObject((String)answerPageRecord.getAnswerContent(), AnswerPageParam.class);
            List<QuestionAnswerParam> questionList = answerPage.getQuestionList();
            questionList.forEach(question -> {
                row.add(question.getTitle());
                String answer = question.getAnswerList().stream().map(answerContent -> {
                    if (question.getType() != 2) {
                        if (StringUtils.isBlank((CharSequence)answerContent.getRequiredAnswer())) {
                            return answerContent.getAnswer();
                        }
                        return String.format(answerContent.getAnswer() + "-%s", answerContent.getRequiredAnswer());
                    }
                    return answerContent.getAnswer();
                }).collect(Collectors.joining(";"));
                row.add(answer);
            });
            return row;
        }).collect(Collectors.toList());
        writer.write(list, writeSheet);
    }

    public static void winPrizeUserExport(List<WinnerRecordDTO> winnerRecordDtoList) {
        if (CollectionUtils.isEmpty(winnerRecordDtoList)) {
            throw new BizRuntimeException("\u6ca1\u6709\u6570\u636e\u5bfc\u51fa");
        }
        ArrayList data = new ArrayList();
        winnerRecordDtoList.forEach(prize -> {
            WinPrizeHeadExcelDTO winPrizeHeadExcelDTO = new WinPrizeHeadExcelDTO();
            winPrizeHeadExcelDTO.setOpenId(prize.getOpenId());
            winPrizeHeadExcelDTO.setUnionID(prize.getUnionId());
            winPrizeHeadExcelDTO.setNick(prize.getNickName());
            winPrizeHeadExcelDTO.setPrize(prize.getPrizeName());
            winPrizeHeadExcelDTO.setPrizeStatus(outPath);
            winPrizeHeadExcelDTO.setReceiveTime(prize.getReceiveTime());
            winPrizeHeadExcelDTO.setOrderId(prize.getOrderId().toString());
            winPrizeHeadExcelDTO.setUsername(prize.getUsername());
            winPrizeHeadExcelDTO.setPhone(prize.getPhone());
            winPrizeHeadExcelDTO.setAddress(prize.getAddress());
            data.add(winPrizeHeadExcelDTO);
        });
        writer.write(data, writeSheet);
    }

    public static void activityDetailExport(List<DataStatisticsParam> dataStatisticsParams) {
        if (CollectionUtils.isEmpty(dataStatisticsParams)) {
            throw new BizRuntimeException("\u65e0\u6570\u636e\u5bfc\u51fa");
        }
        ArrayList data = new ArrayList();
        dataStatisticsParams.forEach(x -> {
            ActivityDetailExcelDTO activityDetailExcelDTO = new ActivityDetailExcelDTO();
            activityDetailExcelDTO.setDate(DateUtils.getDayStr((long)x.getSyncTime()));
            activityDetailExcelDTO.setJoinPv(x.getJoinPv());
            activityDetailExcelDTO.setJoinUv(x.getJoinUv());
            activityDetailExcelDTO.setVisitPv(x.getVisitPv());
            activityDetailExcelDTO.setVisitUv(x.getVisitUv());
            activityDetailExcelDTO.setSubmitCount(x.getSubmitCount());
            activityDetailExcelDTO.setCompletion(x.getCompletion());
            data.add(activityDetailExcelDTO);
        });
        writer.write(data, writeSheet);
    }

    public static void surveyDataExport(List<SurveyDataParam> surveyDataParams) {
        if (CollectionUtils.isEmpty(surveyDataParams)) {
            throw new BizRuntimeException("\u65e0\u6570\u636e\u5bfc\u51fa");
        }
        ArrayList data = new ArrayList();
        surveyDataParams.forEach(x -> {
            SurveyDataExcelDTO surveyDataExcelDTO = new SurveyDataExcelDTO();
            surveyDataExcelDTO.setOption(x.getOption());
            surveyDataExcelDTO.setCount(x.getCount());
            surveyDataExcelDTO.setTitle(x.getTitle());
            surveyDataExcelDTO.setRatio(x.getRatio());
            data.add(surveyDataExcelDTO);
        });
        writer.write(data, writeSheet);
    }

    public static void init(OutputStream out, String sheetName) {
        outputStream = out;
        writer = EasyExcelFactory.write((OutputStream)outputStream, WinPrizeHeadExcelDTO.class).build();
        writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithTemplateAndSheet(String fileName, List<? extends BaseRowModel> data, Sheet sheet) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        sheet = sheet != null ? sheet : new Sheet(0, 1);
        sheet.setClazz(data.get(0).getClass());
        OutputStream outputStream = null;
        ExcelWriter writer = null;
        try {
            outputStream = new FileOutputStream(outPath + fileName);
            writer = EasyExcelFactory.getWriter((OutputStream)outputStream);
            writer.write(data, sheet);
        }
        catch (FileNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)(outPath + fileName));
        }
        finally {
            try {
                if (writer != null) {
                    writer.finish();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
    }
}

