package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import cn.com.duiba.zhongyan.activity.service.api.enums.DeleteFlagEnum;
import cn.com.duiba.zhongyan.activity.service.api.enums.PrizeTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuanyu
 * @description:
 * @date 2021/11/25 7:07 下午
 */
@Data
public class ActivityRulePrizeDTO implements Serializable {
    private static final long serialVersionUID = 3292536975676874246L;

    /**
     * id
     */
    private Long id;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * @see PrizeTypeEnum
     * 奖品类型：1实物
     */
    private Integer prizeType;

    /**
     * 奖品名
     */
    private String name;

    /**
     * spu奖项商品ID
     */
    private Long spuId;

    /**
     * sku奖项商品ID
     */
    private Long skuId;

    /**
     * 商品来源
     */
    private Integer source;

    /**
     * 规格
     */
    private String specification;

    /**
     * 有效时间
     */
    private Long validTime;

    /**
     * @see DeleteFlagEnum
     */
    private Integer deleted;

    /**
     * 奖品图片
     */
    private String image;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 已使用库存
     */
    private Integer usedStock;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
