package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.BasePageParam;
import cn.com.duiba.zhongyan.activity.service.api.base.PageResult;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.JoinActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.PrizeConfigDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.QueryActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.ActivityPageParam;

/**
 * @author xuanyu
 * @description: 活动对外服务
 * @date 2021/11/25 6:05 下午
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 根据id查询活动
     * @param id
     * @return
     */
    ActivityDTO selectById(Long id);

    /**
     * 插入一条数据
     * @param record
     * @return
     */
    Long save(ActivityDTO record);

    /**
     * 选择更新
     * @param record
     * @return
     */
    Boolean updateByIdSelective(ActivityDTO record);


    /**
     * 分页查询活动
     * @param basePageParam
     * @return
     */
    PageResult<ActivityDTO> listPageActivity(BasePageParam basePageParam);

    /**
     * 根据条件参数查询活动
     * @param activityPageParam
     * @return
     * @throws BizException
     */
    PageResult<ActivityDTO> listPageActivityByConditions(ActivityPageParam activityPageParam);

    /**
     * 分页查询活动--参与活动
     * @param activityDTO
     * @return
     */
    PageResult<JoinActivityDTO> listJoinActivityPage(QueryActivityDTO activityDTO);

    /**
     * 获取活动配置的奖品信息
     * @param activityId 活动id
     * @return 活动奖品配置
     */
    PrizeConfigDTO getPrizeConfig(Long activityId) throws BizException;

    /**
     * 获取问卷配置的题目数量
     * @param activityId 活动id
     * @return 活动奖品配置
     */
    Integer getQuestionCount(Long activityId) throws BizException;
}
