package cn.com.duiba.zhongyan.activity.service.api.remoteservice.survey;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.PageResult;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.AnswerPageDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerPageQueryParam;

/**
 * @author xuanyu
 * @description: 答卷服务
 * @date 2021/11/25 6:01 下午
 */
@AdvancedFeignClient
public interface RemoteAnswerPageService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id) throws BizException;

    /**
     * 根据实体插入一条答卷信息
     * @param answerPageDTO 答卷信息
     * @return 主键id
     */
    Long insert(AnswerPageDTO answerPageDTO) throws BizException;

    /**
     * 选择性插入实体中不为null的属性
     * @param answerPageDTO 答卷信息
     * @return 主键id
     */
    Long insertSelective(AnswerPageDTO answerPageDTO) throws BizException;

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条答卷信息
     */
    AnswerPageDTO selectByPrimaryKey(Long id) throws BizException;

    /**
     * 选择性更新实体中不为null的值
     * @param answerPageDTO 答卷信息
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(AnswerPageDTO answerPageDTO) throws BizException;

    /**
     * 根据主键id更新
     * @param answerPageDTO 答卷信息
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(AnswerPageDTO answerPageDTO) throws BizException;

    /**
     * 根据主键id和活动id更新
     * @param answerPageDTO
     * @return
     * @throws BizException
     */
    int updateByUserIdAndActivityId(AnswerPageDTO answerPageDTO) throws BizException;


    /**
     * 根据实体插入一条答卷信息
     * @param answerPageDTO 答卷信息
     * @return 主键id
     */
    Long insertReturnPrimaryKey(AnswerPageDTO answerPageDTO) throws BizException;

    /**
     * 根据参数查询答卷信息(含用户信息）
     * @param answerPageQueryParam 答卷查询参数
     * @return 答卷信息
     */
    PageResult<AnswerPageDTO> listAnswerPageByParam(AnswerPageQueryParam answerPageQueryParam) throws BizException;

    /**
     * 查询总数量
     * @param answerPageQueryParam
     * @return
     * @throws BizException
     */
    Integer countAnswerPageByParam(AnswerPageQueryParam answerPageQueryParam) throws BizException;

    /**
     * 根据参数查询答卷信息
     * @param answerPageDTO
     * @return
     */
    AnswerPageDTO selectAnswerBySelective(AnswerPageDTO answerPageDTO) throws BizException;
}
