package cn.com.duiba.zhongyan.activity.service.api.remoteservice.survey;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.ServiceResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.AnswerRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.SurveyDataDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.MatchConditionUserIdPram;
import cn.com.duiba.zhongyan.activity.service.api.param.PageQuestionAnswerParam;

import java.util.List;
import java.util.Map;

/**
 * @author xuanyu
 * @description: 答题记录对外服务
 * @date 2021/11/25 6:03 下午
 */
@AdvancedFeignClient
public interface RemoteAnswerRecordService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id) throws BizException;

    /**
     * 根据实体插入一条答题记录
     * @param answerRecordDTO 答题记录
     * @return 主键id
     */
    Long insert(AnswerRecordDTO answerRecordDTO) throws BizException;

    /**
     * 选择性插入实体中不为null的属性
     * @param answerRecordDTO 答题记录
     * @return 主键id
     */
    Long insertSelective(AnswerRecordDTO answerRecordDTO) throws BizException;

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条答题记录
     */
    AnswerRecordDTO selectByPrimaryKey(Long id) throws BizException;

    /**
     * 选择性更新实体中不为null的值
     * @param answerRecordDTO 答题记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(AnswerRecordDTO answerRecordDTO) throws BizException;

    /**
     * 根据主键id更新
     * @param answerRecordDTO 答题记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(AnswerRecordDTO answerRecordDTO) throws BizException;


    /**
     * 根据实体批量插入答题记录
     * @param answerRecordDTO 答题记录
     * @return
     */
    int batchInsert(List<AnswerRecordDTO> answerRecordDTO);

    /**
     * 根据活动id查询问卷数据
     * @param activityId
     * @return
     */
    List<SurveyDataDTO> querySurveyData(Long activityId);

    /**
     * 查询满足条件的用户
     * @param pageQuestionAnswerParam 答题记录条件 与关系
     * @return 满足条件的userId列表(随机）
     */
    List<Long> listMatchConditionUserIds(PageQuestionAnswerParam pageQuestionAnswerParam) throws BizException;

    /**
     * 查询满足条件的用户个数
     * @param pageQuestionAnswerParam 答题记录条件 与关系
     * @return 满足条件的userId个数
     */
    Integer countMatchConditionUserIds(PageQuestionAnswerParam pageQuestionAnswerParam) throws BizException;
}
