package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.record.ActivityUserPointDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.record.ActivityUserPointRecordDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.record.ScanCodePageRecordDto;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteChangePointParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteFindPointParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemotePointRecordBindLinkParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteQueryPointParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteScanCodePageListParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteScanCodeParam;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/17
 */
@AdvancedFeignClient
public interface RemoteActivityUserPointService {

    /**
     * 扫码操作
     *
     * @param param
     * @return 记录id
     */
    Long codeScan(RemoteScanCodeParam param);

    /**
     * 查找记录列表
     *
     * @param param
     * @return
     */
    PageResponse<ActivityUserPointRecordDto> queryRecordList(RemoteQueryPointParam param);

    /**
     * 查找单独记录
     *
     * @param recordId
     * @return
     */
    ActivityUserPointRecordDto getByRecordId(Long recordId);


    /**
     * 更新记录
     *
     * @param remotePointRecordBindLinkParam
     * @return
     */
    Boolean updateLink(RemotePointRecordBindLinkParam remotePointRecordBindLinkParam);


    /**
     * 获取积分账户信息
     *
     * @param remoteFindPointParam
     * @return
     */
    ActivityUserPointDto findPoint(RemoteFindPointParam remoteFindPointParam);


    /**
     * 根据条件查询记录
     *
     * @param remoteQueryPointParam
     * @return
     */
    List<ActivityUserPointRecordDto> findRecordByCondition(RemoteQueryPointParam remoteQueryPointParam);

    /**
     * 根据条件查询记录(数量)
     *
     * @param remoteQueryPointParam
     * @return
     */
    Integer findRecordCountByCondition(RemoteQueryPointParam remoteQueryPointParam);


    /**
     * 查询用户详细积分记录列表
     * @param param
     * @return
     */
    PageResponse<ScanCodePageRecordDto> queryAllUserRecordList(RemoteScanCodePageListParam param);

    /**
     * 修改积分
     * @param param
     * @return 增加记录id
     */
     Long changePoint(RemoteChangePointParam param) throws BizException;
}
