package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import cn.com.duiba.zhongyan.activity.service.api.enums.ActivityStateEnum;
import cn.com.duiba.zhongyan.activity.service.api.enums.DeleteFlagEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author XingZhuang
 * @description 活动
 * @date 2021/11/25  4:19 下午
 */

@Data
public class ActivityDTO implements Serializable {

    private static final long serialVersionUID = 3016082900845971969L;

    /**
     * id
     */
    private Long id;

    /**
     * 活动名称
     */
    private String title;

    /**
     * 开始时间
     */
    private Long startTime;

    /**
     * 结束时间
     */
    private Long endTime;

    /**
     * 活动类型
     */
    private String templateType;

    /**
     * @see ActivityStateEnum
     */
    private Byte state;

    /**
     * @see DeleteFlagEnum
     */
    private Byte deleted;

    /**
     * 自定义配置
     */
    private String attributes;

    /**
     * 操作人员
     */
    private String operator;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;


}
