package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDetailDTO;

/**
 * @author xuanyu
 * @description: 活动明细对外服务
 * @date 2021/11/25 6:07 下午
 */
@AdvancedFeignClient
public interface RemoteActivityDetailService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id);

    /**
     * 根据实体插入一条活动明细
     * @param activityDetailDTO 活动明细
     * @return 主键id
     */
    Long insert(ActivityDetailDTO activityDetailDTO);

    /**
     * 选择性插入实体中不为null的属性
     * @param activityDetailDTO 活动明细
     * @return 主键id
     */
    Long insertSelective(ActivityDetailDTO activityDetailDTO);

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条活动明细
     */
    ActivityDetailDTO selectByPrimaryKey(Long id);

    /**
     * 选择性更新实体中不为null的值
     * @param activityDetailDTO 活动明细
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(ActivityDetailDTO activityDetailDTO);

    /**
     * 根据主键id更新
     * @param activityDetailDTO 活动明细
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(ActivityDetailDTO activityDetailDTO);
}
