package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDTO;

/**
 * @author xuanyu
 * @description: 活动对外服务
 * @date 2021/11/25 6:05 下午
 */
@AdvancedFeignClient
public interface RemoteActivityService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id);

    /**
     * 根据实体插入一条活动信息
     * @param activityDTO 活动信息
     * @return 主键id
     */
    Long insert(ActivityDTO activityDTO);

    /**
     * 选择性插入实体中不为null的属性
     * @param activityDTO 活动信息
     * @return 主键id
     */
    Long insertSelective(ActivityDTO activityDTO);

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条活动信息
     */
    ActivityDTO selectByPrimaryKey(Long id);

    /**
     * 选择性更新实体中不为null的值
     * @param activityDTO 活动信息
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(ActivityDTO activityDTO);

    /**
     * 根据主键id更新
     * @param activityDTO 活动信息
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(ActivityDTO activityDTO);
}
