package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeRecordDTO;

/**
 * @author xuanyu
 * @description: 用户中奖记录表对外服务
 * @date 2021/11/25 5:57 下午
 */
@AdvancedFeignClient
public interface RemoteUserPrizeRecordService {
    /**
     * 根据主键删除
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id);

    /**
     * 根据实体插入一条用户中奖记录
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 主键id
     */
    Long insert(UserPrizeRecordDTO userPrizeRecordDTO);

    /**
     * 选择性插入实体中不为null的属性
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 主键id
     */
    Long insertSelective(UserPrizeRecordDTO userPrizeRecordDTO);

    /**
     * 根据主键id查找记录
     * @param id 主键id
     * @return 一条用户中奖记录
     */
    UserPrizeRecordDTO selectByPrimaryKey(Long id);

    /**
     * 选择性更新实体中不为null的值
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(UserPrizeRecordDTO userPrizeRecordDTO);

    /**
     * 根据主键id更新
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(UserPrizeRecordDTO userPrizeRecordDTO);
}
